#pragma once
#ifndef SCRIPTEVENTS_H_
#define SCRIPTEVENTS_H_

#include "Frame.h"
#include "sqlite3.h"
#include "TableAdapters/Connection.h"

using namespace DataAccess;

class ScriptEvents
{
public:
	ScriptEvents(Frame* frame);
	~ScriptEvents();

	void CheckState();
	void LoadNextScene();
	void LoadContinuedMessage();
	void SetCurrentMessage(MessageDataRow* currentMessage) {_currentMessage = currentMessage;}
	void SetPatientName(string patientName) {_patientName = patientName;}
	void SetPhysicianNumber(string physicianNumber) {_physicianNumber = physicianNumber;}
	string ReplaceTextVariables(string text);

	sqlite3* GetDataBase() const {return _dataBase;}
	MessageDataRow* GetCurrentMessage() const {return _currentMessage;}
private:
	string PATIENTTEXT, PHYSICIANTEXT, _patientName, _physicianNumber;
	Connection* _connection;
	CurrentStateDataRow* _currentState;
	Frame* _frame;
	MessageDataRow* _currentMessage;
	sqlite3* _dataBase;
};
#endif //SCRIPTEVENTS_H_